﻿<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Magazyny" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Wiekowanie towarów w magazynach</title>
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>

<script runat="server"> 
    
    public enum OkresMagazynowania {
        [Caption("0-90")]
        [Soneta.Tools.Priority(10)]
        d90 = 0,
        [Caption("91-180")]
        [Soneta.Tools.Priority(20)]
        d180 = 1,
        [Caption("181-365")]
        [Soneta.Tools.Priority(30)]
        d365 = 2,
        [Caption(">365")]
        [Soneta.Tools.Priority(40)]
        pd365 = 3,
        [Caption("Wszystkie")]
        [Soneta.Tools.Priority(50)]
        all = 4,
    }

    public class ParametryBase : SerializableContextBase {
        public ParametryBase(Context cx)
            : base(cx) {
        }

        OkresMagazynowania okresMagazynowania = OkresMagazynowania.d90;

        public OkresMagazynowania OkresMagazynowania {
            get { return okresMagazynowania; }
            set { okresMagazynowania = value; OnChanged(EventArgs.Empty); }
        }

    WgDaty _wgDaty = WgDaty.Partii;

    public WgDaty WgDaty {
      get { return _wgDaty; }
      set { _wgDaty = value; }
    }
  }

  public enum WgDaty
  {
    [Caption("przyjęcia do bieżącego magazynu")]
    Partii,
    [Caption("pierwotnego przyjęcia")]
    PartiiPierwotnej
  }

    static ParametryBase parametry;

    [Context]
    public static ParametryBase Parametry {
        get { return parametry; }
        set { parametry = value; }
    }
    
    public class Total : IComparable {
        readonly Magazyn magazyn;
        readonly Towar towar;
        decimal wart0 = Soneta.Tools.Math.BlankDecimal, wart1 = Soneta.Tools.Math.BlankDecimal, wart2 = Soneta.Tools.Math.BlankDecimal, wart3 = Soneta.Tools.Math.BlankDecimal;
        Quantity ilosc0 = Quantity.Empty, ilosc1 = Quantity.Empty, ilosc2 = Quantity.Empty, ilosc3 = Quantity.Empty;

        public Total(Magazyn magazyn, Towar towar, ObrotyParams pars, Date current, WgDaty wgDaty) {
            this.magazyn = magazyn;
            this.towar = towar;

            Towar t = towar;
            OkresMagazynowy o = pars.Okres;
            Magazyn m = magazyn;

            decimal v0 = Soneta.Tools.Math.BlankDecimal, v1 = Soneta.Tools.Math.BlankDecimal,
                v2 = Soneta.Tools.Math.BlankDecimal, v3 = Soneta.Tools.Math.BlankDecimal;
            Quantity q0 = Quantity.Empty, q1 = Quantity.Empty,
                q2 = Quantity.Empty, q3 = Quantity.Empty;

            foreach (Zasob z in t.Module.Magazyny.Zasoby.WgTowar[t, o, m]) {
                if (z.Partia.Typ == TypPartii.Magazynowy && z.Kierunek == KierunekPartii.Przychód) {
          int dni = Compare( wgDaty, current, z );
                    if (dni <= 90) {
                        q0 += z.Ilosc; v0 += z.Partia.Wartosc;
                    }
                    else if (dni <= 180) {
                        q1 += z.Ilosc; v1 += z.Partia.Wartosc;
                    }
                    else if (dni <= 365) {
                        q2 += z.Ilosc; v2 += z.Partia.Wartosc;
                    }
                    else if (dni > 365) {
                        q3 += z.Ilosc; v3 += z.Partia.Wartosc;
                    }
                }
            }
            ilosc0 = q0;
            ilosc1 = q1;
            ilosc2 = q2;
            ilosc3 = q3;
            wart0 = v0;
            wart1 = v1;
            wart2 = v2;
            wart3 = v3;
    }

    static internal int Compare( WgDaty wgDaty, Date x, Zasob y )
    {
      switch (wgDaty)
      {
        case WgDaty.PartiiPierwotnej:
        {
          return Math.Max( x - y.PartiaPierwotna.Data, 0 );
        }
        default:
        {
          return Math.Max( x - y.Partia.Data, 0 );
        }
      }
    }

        public Magazyn Magazyn {
            get { return magazyn; }
        }

        public Towar Towar {
            get { return towar; }
        }

        public Quantity Ilosc0 {
            get { return ilosc0; }
        }

        public Quantity Ilosc1 {
            get { return ilosc1; }
        }

        public Quantity Ilosc2 {
            get { return ilosc2; }
        }

        public Quantity Ilosc3 {
            get { return ilosc3; }
        }

        public decimal Wartosc0 {
            get { return wart0; }
        }

        public decimal Wartosc1 {
            get { return wart1; }
        }

        public decimal Wartosc2 {
            get { return wart2; }
        }

        public decimal Wartosc3 {
            get { return wart3; }
        }

        public int CompareTo(object obj) {
            Total t = (Total)obj;
            string k1 = Towar.Kod;
            string k2 = t.Towar.Kod;
            int cmp = k1.CompareTo(k2);
            if (cmp != 0)
                return cmp;
            string m1 = Magazyn.Nazwa;
            string m2 = t.Magazyn.Nazwa;
            return m1.CompareTo(m2);
        }
    }

    Magazyn[] magazyny;
    ObrotyParams pars = null;
    
    void dc_ContextLoad(Object sender, EventArgs args) {
        pars = (Soneta.Magazyny.ObrotyParams)dc[typeof(Soneta.Magazyny.ObrotyParams)];

        checkObrotyPars(pars);
        magazyny = pars.Magazyny;
        
        Date current = pars.Okres.Okres.To;
        if (current == Date.MaxValue)
            current = Date.Today;

        var desc = String.Format("W zestawieniu uwzględniono tylko towary, które mają zasoby mieszczące się w przedziale wiekowania: {0} dni.", CaptionAttribute.EnumToString(Parametry.OkresMagazynowania));
        if (Parametry.OkresMagazynowania == OkresMagazynowania.all)
            desc = "W zestawieniu uwzlędniono wszystkie towary o niezerowym stanie magazynowym.";

        if (pars.DataStanu != pars.Okres.Okres.To && pars.DataStanu != Date.Empty)
            throw new InvalidOperationException("Wiekowanie towarów może być robione tylko według stanu aktualnego oraz na koniec okresu magazynowego.");
        
        Row[] towary = (Row[])dc[typeof(Row[])];
        ArrayList arrTotal = new ArrayList();

        ReportHeader.Title += String.Format("Magazyn: <STRONG>{0}|</STRONG>Stan na dzień: <STRONG>{1}</STRONG>||{2}|Wg daty: {3}",
          WydrukiTools.WydrukiStanyMagazynoweLista.FormatMagazyny(magazyny), current, desc, CaptionAttribute.EnumToString( Parametry.WgDaty ));

        foreach (Magazyn m in magazyny)
        {
            foreach (Towar t in towary)
            {
                if (TestTowar(t, m, current))
                    arrTotal.Add(new Total(m, t, pars, current, Parametry.WgDaty));
            }
        }
        
        arrTotal.Sort();
        Grid.DataSource = arrTotal;
    }

    private void checkObrotyPars(ObrotyParams pars) {
        if (pars == null)
            throw new ArgumentNullException("ObrotyParams pars");
        if (pars.Magazyny == null || (pars.Magazyny != null && pars.Magazyny.Length == 0))
            throw new InvalidOperationException("Wymagane jest wybranie przynajmniej jednego magazynu.");
    }

    private bool UwzglednijZasob(Zasob z) {
        if (z.Partia.Typ == TypPartii.Magazynowy && z.Kierunek == KierunekPartii.Przychód)
        {
            return true;
        }
        return false;
    }
    
    bool TestTowar(Towar t, Magazyn m, Date current) {

        SubTable zasoby = t.Module.Magazyny.Zasoby.WgTowar[t, pars.Okres, m];
        
        foreach (Zasob z in zasoby) {
            if (UwzglednijZasob(z)) {
                int dni = Total.Compare( Parametry.WgDaty, current, z );
                if (dni <= 90 && Parametry.OkresMagazynowania == OkresMagazynowania.d90) {
                    return true;
                }
                else if (dni > 90 && dni <= 180 && Parametry.OkresMagazynowania == OkresMagazynowania.d180) {
                    return true;
                }
                else if (dni > 180 && dni <= 365 && Parametry.OkresMagazynowania == OkresMagazynowania.d365) {
                    return true;
                }
                else if (dni > 365 && Parametry.OkresMagazynowania == OkresMagazynowania.pd365) {
                    return true;
                }
                else if (Parametry.OkresMagazynowania == OkresMagazynowania.all) {
                    return true;
                }
            }
        }
        return false;
    }

    protected void Grid_BeforeRow(object sender, RowEventArgs args) {
        // [14085][8.3.1][Handel 8.3.1]: Wiekowanie towarow w magazynach (90, 180, 365, >365) bledne dzialanie
            
        // Total total = (Total)args.Row;
        // Grid.GroupLine = "Towar: " + HttpUtility.HtmlEncode(total.Towar.ToString());
    }
</script>

<body>
    <form method="post" runat="server">
    
    <ea:DataContext ID="dc" runat="server" OnContextLoad="dc_ContextLoad" Landscape="true">
    </ea:DataContext>

    <eb:ReportHeader ID="ReportHeader" Title="Wiekowanie towarów w magazynach|</STRONG>" runat="server"></eb:ReportHeader>

    <ea:Grid ID="Grid" runat="server" RowTypeName="Soneta.Towary.Towar,Soneta.Handel"  
        ShowGroupSum="True" GroupLine="Towar: {0}" GroupData0="Towar"   EncodeHTML="true"
        onbeforerow="Grid_BeforeRow">
        <Columns>
            <ea:GridColumn runat="server" Align="Right" Caption="Lp." DataMember="#" Width="4"
                EncodeHTML="True">
            </ea:GridColumn>
            <ea:GridColumn runat="server" DataMember="Magazyn.Nazwa" Caption="Magazyn" EncodeHTML="True" Total="Info">
            </ea:GridColumn>
            <ea:GridColumn runat="server" DataMember="Ilosc0" Align="Right" Caption="0-90 dni~Ilość"
                Width="10" EncodeHTML="True">
            </ea:GridColumn>
            <ea:GridColumn runat="server" DataMember="Wartosc0" Align="Right" Caption="0-90 dni~Wartość"
                Format="{0:n}" Width="15" Total="Sum" EncodeHTML="True">
            </ea:GridColumn>
            <ea:GridColumn runat="server" DataMember="Ilosc1" Align="Right" Caption="91-180 dni~Ilość"
                Width="10" EncodeHTML="True">
            </ea:GridColumn>
            <ea:GridColumn runat="server" DataMember="Wartosc1" Align="Right" Caption="91-180 dni~Wartość"
                Format="{0:n}" Width="15" Total="Sum" EncodeHTML="True">
            </ea:GridColumn>
            <ea:GridColumn runat="server" DataMember="Ilosc2" Align="Right" Caption="181-365 dni~Ilość"
                Width="10" EncodeHTML="True">
            </ea:GridColumn>
            <ea:GridColumn runat="server" DataMember="Wartosc2" Align="Right" Caption="181-365 dni~Wartość"
                Format="{0:n}" Width="15" Total="Sum" EncodeHTML="True">
            </ea:GridColumn>
            <ea:GridColumn runat="server" DataMember="Ilosc3" Align="Right" Caption="powyżej 365 dni~Ilość"
                Width="10" EncodeHTML="True">
            </ea:GridColumn>
            <ea:GridColumn runat="server" DataMember="Wartosc3" Align="Right" Caption="powyżej 365 dni~Wartość"
                Format="{0:n}" Width="15" Total="Sum" EncodeHTML="True">
            </ea:GridColumn>
        </Columns>
    </ea:Grid>

    <eb:ReportFooter ID="ReportFooter" runat="server">
    </eb:ReportFooter>

    </form>
</body>
</html>

